"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.debugLog = exports.warnLog = exports.removeLinkStyleSheets = exports.buildCSSInjectionCode = void 0;
const vite_1 = require("vite");
const cssInjectedByJsId = '\0vite/all-css';
const defaultInjectCode = (cssCode, { styleId, useStrictCSP }) => `try{if(typeof document != 'undefined'){var elementStyle = document.createElement('style');${typeof styleId == 'string' && styleId.length > 0 ? `elementStyle.id = '${styleId}';` : ''}${useStrictCSP ? `elementStyle.nonce = document.head.querySelector('meta[property=csp-nonce]')?.content;` : ''}elementStyle.appendChild(document.createTextNode(${cssCode}));document.head.appendChild(elementStyle);}}catch(e){console.error('vite-plugin-css-injected-by-js', e);}`;
function buildCSSInjectionCode({ cssToInject, styleId, injectCode, injectCodeFunction, useStrictCSP, }) {
    return __awaiter(this, void 0, void 0, function* () {
        const res = yield (0, vite_1.build)({
            root: '',
            configFile: false,
            logLevel: 'error',
            plugins: [injectionCSSCodePlugin({ cssToInject, styleId, injectCode, injectCodeFunction, useStrictCSP })],
            build: {
                write: false,
                target: 'es2015',
                minify: 'esbuild',
                assetsDir: '',
                rollupOptions: {
                    input: {
                        ['all-css']: cssInjectedByJsId,
                    },
                    output: {
                        format: 'iife',
                        manualChunks: undefined,
                    },
                },
            },
        });
        const _cssChunk = Array.isArray(res) ? res[0] : res;
        if (!('output' in _cssChunk))
            return null;
        return _cssChunk.output[0];
    });
}
exports.buildCSSInjectionCode = buildCSSInjectionCode;
function injectionCSSCodePlugin({ cssToInject, injectCode, injectCodeFunction, styleId, useStrictCSP, }) {
    return {
        name: 'vite:injection-css-code-plugin',
        resolveId(id) {
            if (id == cssInjectedByJsId) {
                return id;
            }
        },
        load(id) {
            if (id == cssInjectedByJsId) {
                const cssCode = JSON.stringify(cssToInject.trim());
                if (injectCodeFunction) {
                    return `(${injectCodeFunction})(${cssCode}, ${JSON.stringify({ styleId, useStrictCSP })})`;
                }
                const injectFunction = injectCode || defaultInjectCode;
                return injectFunction(cssCode, { styleId, useStrictCSP });
            }
        },
    };
}
function removeLinkStyleSheets(html, cssFileName) {
    const removeCSS = new RegExp(`<link rel=".*"[^>]*?href=".*/?${cssFileName}"[^>]*?>`);
    return html.replace(removeCSS, '');
}
exports.removeLinkStyleSheets = removeLinkStyleSheets;
function warnLog(msg) {
    console.warn(`\x1b[33m \n${msg} \x1b[39m`);
}
exports.warnLog = warnLog;
function debugLog(msg) {
    console.debug(`\x1b[34m \n${msg} \x1b[39m`);
}
exports.debugLog = debugLog;
