import { OutputChunk } from 'rollup';
import { BuildCSSInjectionConfiguration } from './interface';
interface InjectCodeOptions {
    styleId?: string;
    useStrictCSP?: boolean;
}
export type InjectCode = (cssCode: string, options: InjectCodeOptions) => string;
export type InjectCodeFunction = (cssCode: string, options: InjectCodeOptions) => void;
export declare function buildCSSInjectionCode({ cssToInject, styleId, injectCode, injectCodeFunction, useStrictCSP, }: BuildCSSInjectionConfiguration): Promise<OutputChunk | null>;
export declare function removeLinkStyleSheets(html: string, cssFileName: string): string;
export declare function warnLog(msg: string): void;
export declare function debugLog(msg: string): void;
export {};
