import type { ICalendarItem, INormalizedCalendarItem, DateTimeFormatOption } from "./ICalendarItem";
declare const _default: {
    addDays: (d: Date, days: number) => Date;
    beginningOfMonth: (d: Date) => Date;
    beginningOfPeriod: (d: Date, periodUom: string, startDow: number) => Date;
    beginningOfWeek: (d: Date, startDow: number) => Date;
    dateOnly: (d: string | Date) => Date;
    dayDiff: (d1: Date, d2: Date) => number;
    daysOfWeek: (weekStart: Date) => Date[];
    endOfWeek: (d: Date, startDow: number) => Date;
    formattedPeriod: (startDate: Date, endDate: Date, periodUom: string, monthNames: string[]) => string;
    formattedTime: (d: Date, locale: string, options?: Intl.DateTimeFormatOptions | undefined) => string;
    fromIsoStringToLocalDate: (s: string) => Date;
    getDefaultBrowserLocale: () => string;
    getFormattedMonthNames: (locale: string, format: DateTimeFormatOption) => string[];
    getFormattedWeekdayNames: (locale: string, format: DateTimeFormatOption, startingDayOfWeek: number) => string[];
    incrementPeriod: (d: Date, uom: string, count: number) => Date;
    instanceOfMonth: (d: Date) => number;
    isFutureMonth: (d: Date) => boolean;
    isInFuture: (d: Date) => boolean;
    isInPast: (d: Date) => boolean;
    isLastDayOfMonth: (d: Date) => boolean;
    isLastInstanceOfMonth: (d: Date) => boolean;
    isoMonthDay: (d: Date) => string;
    isoYearMonth: (d: Date) => string;
    isoYearMonthDay: (d: Date) => string;
    isPastMonth: (d: Date) => boolean;
    isSameDate: (d1?: Date | undefined, d2?: Date | undefined) => boolean;
    isSameDateTime: (d1?: Date | undefined, d2?: Date | undefined) => boolean;
    isSameMonth: (d1?: Date | undefined, d2?: Date | undefined) => boolean;
    languageCode: (l: string) => string;
    normalizeItem: (item: ICalendarItem, isHovered: boolean) => INormalizedCalendarItem;
    paddedDay: (d: Date) => string;
    paddedMonth: (d: Date) => string;
    supportsIntl: () => boolean;
    today: () => Date;
    toLocalDate: (d: any) => Date;
};
export default _default;
